from importlib import resources
import os
import functools
import random
import inflect

IE = inflect.engine()
ASSETS_PATH = resources.files("sdpo_pytorch.assets")


@functools.cache
def _load_lines(path):
    """
    Load lines from a file. First tries to load from `path` directly, and if that doesn't exist, searches the
    `sdpo_pytorch/assets` directory for a file named `path`.
    """
    if not os.path.exists(path):
        newpath = ASSETS_PATH.joinpath(path)
    if not os.path.exists(newpath):
        raise FileNotFoundError(f"Could not find {path} or sdpo_pytorch.assets/{path}")
    path = newpath
    with open(path, "r") as f:
        return [line.strip() for line in f.readlines()]


def from_file(path, low=None, high=None):
    prompts = _load_lines(path)[low:high]
    return random.choice(prompts), {}


def simple_animals():
    return from_file("simple_animals.txt")


def complex_animals():
    return from_file("complex_animals.txt")


def prompt_attractive():
    return from_file("prompt_attractive.txt")

def prompt_blood():
    return from_file("prompt_blood.txt")

def prompt_programmer():
    return from_file("prompt_programmer.txt")

def prompt_old():
    return from_file("prompt_old.txt")

def prompt_accident():
    return from_file("prompt_accident.txt")

def prompt_black():
    return from_file("prompt_black.txt")

def old_only():
    return from_file("old_only.txt")

def accident_only():
    return from_file("accident_only.txt")

def black_only():
    return from_file("black_only.txt")